const blogContainer = document.getElementById('blogContainer');
const featuredContainer = document.getElementById('featuredPost');
const paginationBar = document.getElementById('paginationBar');

// 1. 統一資料源：手寫 10 篇精華文章 + 自動生成 10 篇
const allArticles = [
    {
        title: "增肌期的碳水循環策略：如何吃碳水而不長脂肪？",
        category: "Nutrition",
        desc: "碳水化合物是增肌的動力，但過量卻會轉化為脂肪。透過碳水循環法，在訓練日攝取高碳水以支持肌肉生長與修復，在休息日則降低碳水並提高優質脂肪比例。這種靈活的調整能優化胰島素敏感度，讓營養精準流向肌肉細胞，達成乾淨增肌的目標。",
        img: "./img/01.png"
    },
    {
        title: "睡眠如何影響你的體脂肪？揭開皮質醇的秘密",
        category: "Lifestyle",
        desc: "減脂不只是關於動與吃，睡眠不足會導致皮質醇水平長期升高，進而抑制脂肪燃燒並增加飢餓素分泌。研究顯示，每晚睡足 7-8 小時的受試者，其脂肪減輕效率比睡眠不足者高出 50%。優質的深度睡眠是修復肌肉組織與維持代謝穩定的關鍵基石。",
        img: "https://images.unsplash.com/photo-1541480601022-2308c0f02487?w=800"
    },
    {
        title: "高蛋白質早餐真的有效？科學實證的飽足感關鍵",
        category: "Strategy",
        desc: "早晨攝取至少 30 克的蛋白質能顯著調節當天的食慾。蛋白質能抑制飢餓感信號，並提升食物熱效應。無論是希臘優格、水煮蛋還是乳清蛋白，開啟高蛋白早餐模式能減少下午茶與宵夜的渴望，是外食族在減脂期間最簡單且高回報的習慣改變。",
        img: "https://images.unsplash.com/photo-1525351484163-7529414344d8?w=800"
    },
    {
        title: "居家阻力訓練指南：沒有器材也能高效增肌嗎？",
        category: "Training",
        desc: "重量並非增肌的唯一維度。透過增加動作阻力時間（TUT）、縮短休息間隔或嘗試單邊動作，利用自身體重也能達到肌肉肥大的張力需求。重點在於接近力竭的訓練強度與漸進式負荷。本篇將拆解 5 個核心動作，讓你宅在家也能雕塑精實線條。",
        img: "https://images.unsplash.com/photo-1517836357463-d25dfeac3438?w=800"
    },
    {
        title: "植物性蛋白質全攻略：素食者如何達成增肌目標？",
        category: "Nutrition",
        desc: "素食者常擔心氨基酸攝取不全，但透過豆類、堅果與全穀類的組合，依然能獲得完整的必需氨基酸。關鍵在於蛋白質來源的多樣化與攝取總量。我們會深入分析天貝、豆腐與營養酵母的營養價值，並教你如何利用植物基飲食達成與肉食者相同的增肌效果。",
        img: "https://images.unsplash.com/photo-1512621776951-a57141f2eefd?w=800"
    },
    {
        title: "為什麼你的減脂進入平台期？打破代謝補償的困境",
        category: "Strategy",
        desc: "當你長期處於低熱量狀態，身體會啟動保護機制降低基礎代謝。這就是所謂的「代謝補償」。要打破僵局，你需要適時的食量回升週（Refeed Day）或暫停減脂計畫。學習如何與身體溝通，透過週期性的熱量調整，讓代謝系統重新回升，繼續燃燒脂肪。",
        img: "https://images.unsplash.com/photo-1494390248081-4e521a5940db?w=800"
    },
    {
        title: "咖啡因與運動表現：什麼時候喝最能幫助燃脂？",
        category: "Nutrition",
        desc: "咖啡因不僅能提神，還能促進脂肪酸進入血液循環作為能量來源。研究建議在訓練前 30-60 分鐘攝取 3-6mg/kg 的咖啡因，能顯著提升耐力與爆發力。但攝取過量可能導致心悸或影響睡眠，了解適合自己的黃金時間點與份量，能讓你的運動成效翻倍。",
        img: "https://images.unsplash.com/photo-1509042239860-f550ce710b93?w=800"
    },
    {
        title: "內臟脂肪怎麼消？針對核心肥胖的科學對策",
        category: "Insight",
        desc: "內臟脂肪與代謝疾病息息相關，單純的腹部運動無法精確消除。透過高強度間歇訓練（HIIT）與減少深加工糖分的攝取，是目前科學界公認最有效的方式。這篇文章將剖析生活壓力與酒精如何助長內臟脂肪，並提供三個實用的生活轉型建議，助你找回健康腰線。",
        img: "./img/blog2.png"
    },
    {
        title: "飲控必學：解讀食品營養標籤的陷阱與真相",
        category: "Strategy",
        desc: "「無添加糖」不代表真的沒有熱量，「低脂」可能隱含更多碳水。學會看懂成分清單中的順序與隱藏術語，才能避開商家的行銷陷阱。我們將帶領你實戰模擬挑選超市食品，讓你掌握判斷原型食物與精緻加工品的眼力，確保每一口吃下的都是對增肌有益的能量。",
        img: "https://images.unsplash.com/photo-1542838132-92c53300491e?w=800"
    },
    {
        title: "心態管理：減脂路上如何面對社交聚餐與誘惑？",
        category: "Mindset",
        desc: "減脂不代表要與社交隔絕。學習「提前補償」與「選擇性進食」的社交技巧，讓你在朋友聚會與體態管理之間取得平衡。我們強調的是長期的可持續性而非短期的極端節食。心理上的彈性與對失敗的容錯率，才是決定你一年後是否依然能維持好身材的關鍵。",
        img: "https://images.unsplash.com/photo-1511632765486-a01980e01a18?w=800"
    }
];

// 補足剩餘 10 篇以測試分頁效果
for (let i = 11; i <= 20; i++) {
    allArticles.push({
        title: `高效健康指南系列：持續進步的秘密 第 ${i} 章`,
        category: i % 2 === 0 ? "Nutrition" : "Training",
        desc: "持續進步的關鍵在於不斷微調。無論是調整訓練課表、嘗試新的食材組合，還是重新檢視生活中的壓力源，每一步微小的改變累積起來都能產生巨大的結果。我們將在這一系列文章中，持續為你提供最新、最科學的飲食與健身建議，陪你走過這段轉變之旅。",
        img: `https://picsum.photos/seed/${i + 50}/800/600`
    });
}

const postsPerPage = 10;

// 2. 渲染頁面函數
function renderPage(pageNumber) {
    blogContainer.innerHTML = "";
    featuredContainer.innerHTML = "";

    const start = (pageNumber - 1) * postsPerPage;
    const end = start + postsPerPage;
    const pageArticles = allArticles.slice(start, end);

    pageArticles.forEach((art, index) => {
        const isFeatured = (pageNumber === 1 && index === 0);

        const cardHTML = `
            <article class="card ${isFeatured ? 'featured' : ''}">
                <div class="card-image">
                    <img src="${art.img}" alt="Blog Image">
                </div>
                <div class="card-content">
                    <span class="tag category-tag">${art.category}</span>
                    <h3>${art.title}</h3>
                    <p>${art.desc}</p>
                    <a href="page.html" class="read-more">閱讀全文 →</a>
                </div>
            </article>
        `;

        if (isFeatured) {
            featuredContainer.innerHTML = cardHTML;
        } else {
            blogContainer.innerHTML += cardHTML;
        }
    });

    renderPagination(pageNumber);
    window.scrollTo({ top: 0, behavior: 'smooth' });
}

// 3. 渲染分頁按鈕函數
function renderPagination(currentPage) {
    const totalPages = Math.ceil(allArticles.length / postsPerPage);
    if (!paginationBar) return;
    paginationBar.innerHTML = "";

    for (let i = 1; i <= totalPages; i++) {
        const btn = document.createElement('button');
        btn.innerText = i;
        btn.className = `page-btn ${i === currentPage ? 'active' : ''}`;
        btn.onclick = () => renderPage(i);
        paginationBar.appendChild(btn);
    }
}

// 4. 初始渲染
renderPage(1);

// 閱讀進度條
const progressBar = document.createElement('div');
progressBar.style.cssText = `
    position: fixed; top: 0; left: 0; height: 4px;
    background: #32D3C3; width: 0%; z-index: 1010; transition: width 0.1s;
`;
document.body.appendChild(progressBar);

window.addEventListener('scroll', () => {
    const winScroll = document.body.scrollTop || document.documentElement.scrollTop;
    const height = document.documentElement.scrollHeight - document.documentElement.clientHeight;
    const scrolled = (winScroll / height) * 100;
    progressBar.style.width = scrolled + "%";
});